package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Ac3CodingMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Ac3CodingMode
}
object Ac3CodingMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Ac3CodingMode
  ): zio.aws.medialive.model.Ac3CodingMode = value match {
    case software.amazon.awssdk.services.medialive.model.Ac3CodingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_1_0 =>
      val r = CODING_MODE_1_0
      r
    case software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_1_1 =>
      val r = CODING_MODE_1_1
      r
    case software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_2_0 =>
      val r = CODING_MODE_2_0
      r
    case software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_3_2_LFE =>
      val r = CODING_MODE_3_2_LFE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Ac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Ac3CodingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CODING_MODE_1_0 extends zio.aws.medialive.model.Ac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_1_0
  }
  case object CODING_MODE_1_1 extends zio.aws.medialive.model.Ac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_1_1
  }
  case object CODING_MODE_2_0 extends zio.aws.medialive.model.Ac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_2_0
  }
  case object CODING_MODE_3_2_LFE
      extends zio.aws.medialive.model.Ac3CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3CodingMode =
      software.amazon.awssdk.services.medialive.model.Ac3CodingMode.CODING_MODE_3_2_LFE
  }
}
