package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Ac3MetadataControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.Ac3MetadataControl
}
object Ac3MetadataControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Ac3MetadataControl
  ): zio.aws.medialive.model.Ac3MetadataControl = value match {
    case software.amazon.awssdk.services.medialive.model.Ac3MetadataControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Ac3MetadataControl.FOLLOW_INPUT =>
      val r = FOLLOW_INPUT
      r
    case software.amazon.awssdk.services.medialive.model.Ac3MetadataControl.USE_CONFIGURED =>
      val r = USE_CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Ac3MetadataControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3MetadataControl =
      software.amazon.awssdk.services.medialive.model.Ac3MetadataControl.UNKNOWN_TO_SDK_VERSION
  }
  case object FOLLOW_INPUT extends zio.aws.medialive.model.Ac3MetadataControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3MetadataControl =
      software.amazon.awssdk.services.medialive.model.Ac3MetadataControl.FOLLOW_INPUT
  }
  case object USE_CONFIGURED
      extends zio.aws.medialive.model.Ac3MetadataControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Ac3MetadataControl =
      software.amazon.awssdk.services.medialive.model.Ac3MetadataControl.USE_CONFIGURED
  }
}
