package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin1Max31, __double}
import scala.jdk.CollectionConverters._
final case class Ac3Settings(
    bitrate: Option[__double] = None,
    bitstreamMode: Option[zio.aws.medialive.model.Ac3BitstreamMode] = None,
    codingMode: Option[zio.aws.medialive.model.Ac3CodingMode] = None,
    dialnorm: Option[__integerMin1Max31] = None,
    drcProfile: Option[zio.aws.medialive.model.Ac3DrcProfile] = None,
    lfeFilter: Option[zio.aws.medialive.model.Ac3LfeFilter] = None,
    metadataControl: Option[zio.aws.medialive.model.Ac3MetadataControl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Ac3Settings = {
    import Ac3Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Ac3Settings
      .builder()
      .optionallyWith(bitrate.map(value => value: java.lang.Double))(_.bitrate)
      .optionallyWith(bitstreamMode.map(value => value.unwrap))(_.bitstreamMode)
      .optionallyWith(codingMode.map(value => value.unwrap))(_.codingMode)
      .optionallyWith(dialnorm.map(value => value: Integer))(_.dialnorm)
      .optionallyWith(drcProfile.map(value => value.unwrap))(_.drcProfile)
      .optionallyWith(lfeFilter.map(value => value.unwrap))(_.lfeFilter)
      .optionallyWith(metadataControl.map(value => value.unwrap))(
        _.metadataControl
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Ac3Settings.ReadOnly =
    zio.aws.medialive.model.Ac3Settings.wrap(buildAwsValue())
}
object Ac3Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Ac3Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Ac3Settings =
      zio.aws.medialive.model.Ac3Settings(
        bitrate.map(value => value),
        bitstreamMode.map(value => value),
        codingMode.map(value => value),
        dialnorm.map(value => value),
        drcProfile.map(value => value),
        lfeFilter.map(value => value),
        metadataControl.map(value => value)
      )
    def bitrate: Option[__double]
    def bitstreamMode: Option[zio.aws.medialive.model.Ac3BitstreamMode]
    def codingMode: Option[zio.aws.medialive.model.Ac3CodingMode]
    def dialnorm: Option[__integerMin1Max31]
    def drcProfile: Option[zio.aws.medialive.model.Ac3DrcProfile]
    def lfeFilter: Option[zio.aws.medialive.model.Ac3LfeFilter]
    def metadataControl: Option[zio.aws.medialive.model.Ac3MetadataControl]
    def getBitrate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getBitstreamMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Ac3BitstreamMode] =
      AwsError.unwrapOptionField("bitstreamMode", bitstreamMode)
    def getCodingMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Ac3CodingMode] =
      AwsError.unwrapOptionField("codingMode", codingMode)
    def getDialnorm: ZIO[Any, AwsError, __integerMin1Max31] =
      AwsError.unwrapOptionField("dialnorm", dialnorm)
    def getDrcProfile
        : ZIO[Any, AwsError, zio.aws.medialive.model.Ac3DrcProfile] =
      AwsError.unwrapOptionField("drcProfile", drcProfile)
    def getLfeFilter: ZIO[Any, AwsError, zio.aws.medialive.model.Ac3LfeFilter] =
      AwsError.unwrapOptionField("lfeFilter", lfeFilter)
    def getMetadataControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.Ac3MetadataControl] =
      AwsError.unwrapOptionField("metadataControl", metadataControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Ac3Settings
  ) extends zio.aws.medialive.model.Ac3Settings.ReadOnly {
    override val bitrate: Option[__double] =
      scala.Option(impl.bitrate()).map(value => value: __double)
    override val bitstreamMode
        : Option[zio.aws.medialive.model.Ac3BitstreamMode] = scala
      .Option(impl.bitstreamMode())
      .map(value => zio.aws.medialive.model.Ac3BitstreamMode.wrap(value))
    override val codingMode: Option[zio.aws.medialive.model.Ac3CodingMode] =
      scala
        .Option(impl.codingMode())
        .map(value => zio.aws.medialive.model.Ac3CodingMode.wrap(value))
    override val dialnorm: Option[__integerMin1Max31] =
      scala.Option(impl.dialnorm()).map(value => value: __integerMin1Max31)
    override val drcProfile: Option[zio.aws.medialive.model.Ac3DrcProfile] =
      scala
        .Option(impl.drcProfile())
        .map(value => zio.aws.medialive.model.Ac3DrcProfile.wrap(value))
    override val lfeFilter: Option[zio.aws.medialive.model.Ac3LfeFilter] = scala
      .Option(impl.lfeFilter())
      .map(value => zio.aws.medialive.model.Ac3LfeFilter.wrap(value))
    override val metadataControl
        : Option[zio.aws.medialive.model.Ac3MetadataControl] = scala
      .Option(impl.metadataControl())
      .map(value => zio.aws.medialive.model.Ac3MetadataControl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Ac3Settings
  ): zio.aws.medialive.model.Ac3Settings.ReadOnly = new Wrapper(impl)
}
