package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AcceptHeader {
  def unwrap: software.amazon.awssdk.services.medialive.model.AcceptHeader
}
object AcceptHeader {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AcceptHeader
  ): zio.aws.medialive.model.AcceptHeader = value match {
    case software.amazon.awssdk.services.medialive.model.AcceptHeader.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AcceptHeader.IMAGE_JPEG =>
      val r = `image/jpeg`
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AcceptHeader {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AcceptHeader =
      software.amazon.awssdk.services.medialive.model.AcceptHeader.UNKNOWN_TO_SDK_VERSION
  }
  case object `image/jpeg` extends zio.aws.medialive.model.AcceptHeader {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AcceptHeader =
      software.amazon.awssdk.services.medialive.model.AcceptHeader.IMAGE_JPEG
  }
}
