package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AfdSignaling {
  def unwrap: software.amazon.awssdk.services.medialive.model.AfdSignaling
}
object AfdSignaling {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AfdSignaling
  ): zio.aws.medialive.model.AfdSignaling = value match {
    case software.amazon.awssdk.services.medialive.model.AfdSignaling.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AfdSignaling.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.AfdSignaling.FIXED =>
      val r = FIXED
      r
    case software.amazon.awssdk.services.medialive.model.AfdSignaling.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AfdSignaling {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AfdSignaling =
      software.amazon.awssdk.services.medialive.model.AfdSignaling.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.AfdSignaling {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AfdSignaling =
      software.amazon.awssdk.services.medialive.model.AfdSignaling.AUTO
  }
  case object FIXED extends zio.aws.medialive.model.AfdSignaling {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AfdSignaling =
      software.amazon.awssdk.services.medialive.model.AfdSignaling.FIXED
  }
  case object NONE extends zio.aws.medialive.model.AfdSignaling {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AfdSignaling =
      software.amazon.awssdk.services.medialive.model.AfdSignaling.NONE
  }
}
