package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1Max4
import scala.jdk.CollectionConverters._
final case class AncillarySourceSettings(
    sourceAncillaryChannelNumber: Option[__integerMin1Max4] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AncillarySourceSettings = {
    import AncillarySourceSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AncillarySourceSettings
      .builder()
      .optionallyWith(
        sourceAncillaryChannelNumber.map(value => value: Integer)
      )(_.sourceAncillaryChannelNumber)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AncillarySourceSettings.ReadOnly =
    zio.aws.medialive.model.AncillarySourceSettings.wrap(buildAwsValue())
}
object AncillarySourceSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AncillarySourceSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AncillarySourceSettings =
      zio.aws.medialive.model.AncillarySourceSettings(
        sourceAncillaryChannelNumber.map(value => value)
      )
    def sourceAncillaryChannelNumber: Option[__integerMin1Max4]
    def getSourceAncillaryChannelNumber: ZIO[Any, AwsError, __integerMin1Max4] =
      AwsError.unwrapOptionField(
        "sourceAncillaryChannelNumber",
        sourceAncillaryChannelNumber
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AncillarySourceSettings
  ) extends zio.aws.medialive.model.AncillarySourceSettings.ReadOnly {
    override val sourceAncillaryChannelNumber: Option[__integerMin1Max4] = scala
      .Option(impl.sourceAncillaryChannelNumber())
      .map(value => value: __integerMin1Max4)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AncillarySourceSettings
  ): zio.aws.medialive.model.AncillarySourceSettings.ReadOnly = new Wrapper(
    impl
  )
}
