package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArchiveCdnSettings(
    archiveS3Settings: Option[zio.aws.medialive.model.ArchiveS3Settings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ArchiveCdnSettings = {
    import ArchiveCdnSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ArchiveCdnSettings
      .builder()
      .optionallyWith(archiveS3Settings.map(value => value.buildAwsValue()))(
        _.archiveS3Settings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ArchiveCdnSettings.ReadOnly =
    zio.aws.medialive.model.ArchiveCdnSettings.wrap(buildAwsValue())
}
object ArchiveCdnSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ArchiveCdnSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ArchiveCdnSettings =
      zio.aws.medialive.model
        .ArchiveCdnSettings(archiveS3Settings.map(value => value.asEditable))
    def archiveS3Settings
        : Option[zio.aws.medialive.model.ArchiveS3Settings.ReadOnly]
    def getArchiveS3Settings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ArchiveS3Settings.ReadOnly
    ] = AwsError.unwrapOptionField("archiveS3Settings", archiveS3Settings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveCdnSettings
  ) extends zio.aws.medialive.model.ArchiveCdnSettings.ReadOnly {
    override val archiveS3Settings
        : Option[zio.aws.medialive.model.ArchiveS3Settings.ReadOnly] = scala
      .Option(impl.archiveS3Settings())
      .map(value => zio.aws.medialive.model.ArchiveS3Settings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveCdnSettings
  ): zio.aws.medialive.model.ArchiveCdnSettings.ReadOnly = new Wrapper(impl)
}
