package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ArchiveContainerSettings(
    m2tsSettings: Option[zio.aws.medialive.model.M2tsSettings] = None,
    rawSettings: Option[zio.aws.medialive.model.RawSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ArchiveContainerSettings = {
    import ArchiveContainerSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ArchiveContainerSettings
      .builder()
      .optionallyWith(m2tsSettings.map(value => value.buildAwsValue()))(
        _.m2tsSettings
      )
      .optionallyWith(rawSettings.map(value => value.buildAwsValue()))(
        _.rawSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ArchiveContainerSettings.ReadOnly =
    zio.aws.medialive.model.ArchiveContainerSettings.wrap(buildAwsValue())
}
object ArchiveContainerSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ArchiveContainerSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ArchiveContainerSettings =
      zio.aws.medialive.model.ArchiveContainerSettings(
        m2tsSettings.map(value => value.asEditable),
        rawSettings.map(value => value.asEditable)
      )
    def m2tsSettings: Option[zio.aws.medialive.model.M2tsSettings.ReadOnly]
    def rawSettings: Option[zio.aws.medialive.model.RawSettings.ReadOnly]
    def getM2tsSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsSettings.ReadOnly] =
      AwsError.unwrapOptionField("m2tsSettings", m2tsSettings)
    def getRawSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.RawSettings.ReadOnly] =
      AwsError.unwrapOptionField("rawSettings", rawSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveContainerSettings
  ) extends zio.aws.medialive.model.ArchiveContainerSettings.ReadOnly {
    override val m2tsSettings
        : Option[zio.aws.medialive.model.M2tsSettings.ReadOnly] = scala
      .Option(impl.m2tsSettings())
      .map(value => zio.aws.medialive.model.M2tsSettings.wrap(value))
    override val rawSettings
        : Option[zio.aws.medialive.model.RawSettings.ReadOnly] = scala
      .Option(impl.rawSettings())
      .map(value => zio.aws.medialive.model.RawSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveContainerSettings
  ): zio.aws.medialive.model.ArchiveContainerSettings.ReadOnly = new Wrapper(
    impl
  )
}
