package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin1
import scala.jdk.CollectionConverters._
final case class ArchiveGroupSettings(
    archiveCdnSettings: Option[zio.aws.medialive.model.ArchiveCdnSettings] =
      None,
    destination: zio.aws.medialive.model.OutputLocationRef,
    rolloverInterval: Option[__integerMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings = {
    import ArchiveGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings
      .builder()
      .optionallyWith(archiveCdnSettings.map(value => value.buildAwsValue()))(
        _.archiveCdnSettings
      )
      .destination(destination.buildAwsValue())
      .optionallyWith(rolloverInterval.map(value => value: Integer))(
        _.rolloverInterval
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ArchiveGroupSettings.ReadOnly =
    zio.aws.medialive.model.ArchiveGroupSettings.wrap(buildAwsValue())
}
object ArchiveGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ArchiveGroupSettings =
      zio.aws.medialive.model.ArchiveGroupSettings(
        archiveCdnSettings.map(value => value.asEditable),
        destination.asEditable,
        rolloverInterval.map(value => value)
      )
    def archiveCdnSettings
        : Option[zio.aws.medialive.model.ArchiveCdnSettings.ReadOnly]
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def rolloverInterval: Option[__integerMin1]
    def getArchiveCdnSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.ArchiveCdnSettings.ReadOnly
    ] = AwsError.unwrapOptionField("archiveCdnSettings", archiveCdnSettings)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
    def getRolloverInterval: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("rolloverInterval", rolloverInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings
  ) extends zio.aws.medialive.model.ArchiveGroupSettings.ReadOnly {
    override val archiveCdnSettings
        : Option[zio.aws.medialive.model.ArchiveCdnSettings.ReadOnly] = scala
      .Option(impl.archiveCdnSettings())
      .map(value => zio.aws.medialive.model.ArchiveCdnSettings.wrap(value))
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
    override val rolloverInterval: Option[__integerMin1] =
      scala.Option(impl.rolloverInterval()).map(value => value: __integerMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings
  ): zio.aws.medialive.model.ArchiveGroupSettings.ReadOnly = new Wrapper(impl)
}
