package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ArchiveOutputSettings(
    containerSettings: zio.aws.medialive.model.ArchiveContainerSettings,
    extension: Option[__string] = None,
    nameModifier: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings = {
    import ArchiveOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings
      .builder()
      .containerSettings(containerSettings.buildAwsValue())
      .optionallyWith(extension.map(value => value: java.lang.String))(
        _.extension
      )
      .optionallyWith(nameModifier.map(value => value: java.lang.String))(
        _.nameModifier
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.ArchiveOutputSettings.ReadOnly =
    zio.aws.medialive.model.ArchiveOutputSettings.wrap(buildAwsValue())
}
object ArchiveOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.ArchiveOutputSettings =
      zio.aws.medialive.model.ArchiveOutputSettings(
        containerSettings.asEditable,
        extension.map(value => value),
        nameModifier.map(value => value)
      )
    def containerSettings
        : zio.aws.medialive.model.ArchiveContainerSettings.ReadOnly
    def extension: Option[__string]
    def nameModifier: Option[__string]
    def getContainerSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.ArchiveContainerSettings.ReadOnly
    ] = ZIO.succeed(containerSettings)
    def getExtension: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("extension", extension)
    def getNameModifier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nameModifier", nameModifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings
  ) extends zio.aws.medialive.model.ArchiveOutputSettings.ReadOnly {
    override val containerSettings
        : zio.aws.medialive.model.ArchiveContainerSettings.ReadOnly =
      zio.aws.medialive.model.ArchiveContainerSettings
        .wrap(impl.containerSettings())
    override val extension: Option[__string] =
      scala.Option(impl.extension()).map(value => value: __string)
    override val nameModifier: Option[__string] =
      scala.Option(impl.nameModifier()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings
  ): zio.aws.medialive.model.ArchiveOutputSettings.ReadOnly = new Wrapper(impl)
}
