package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__integerMin0Max7
import scala.jdk.CollectionConverters._
final case class AudioChannelMapping(
    inputChannelLevels: Iterable[zio.aws.medialive.model.InputChannelLevel],
    outputChannel: __integerMin0Max7
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioChannelMapping = {
    import AudioChannelMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioChannelMapping
      .builder()
      .inputChannelLevels(inputChannelLevels.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .outputChannel(outputChannel: Integer)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioChannelMapping.ReadOnly =
    zio.aws.medialive.model.AudioChannelMapping.wrap(buildAwsValue())
}
object AudioChannelMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioChannelMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioChannelMapping =
      zio.aws.medialive.model.AudioChannelMapping(
        inputChannelLevels.map { item =>
          item.asEditable
        },
        outputChannel
      )
    def inputChannelLevels
        : List[zio.aws.medialive.model.InputChannelLevel.ReadOnly]
    def outputChannel: __integerMin0Max7
    def getInputChannelLevels: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.InputChannelLevel.ReadOnly
    ]] = ZIO.succeed(inputChannelLevels)
    def getOutputChannel: ZIO[Any, Nothing, __integerMin0Max7] =
      ZIO.succeed(outputChannel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioChannelMapping
  ) extends zio.aws.medialive.model.AudioChannelMapping.ReadOnly {
    override val inputChannelLevels
        : List[zio.aws.medialive.model.InputChannelLevel.ReadOnly] = impl
      .inputChannelLevels()
      .asScala
      .map { item =>
        zio.aws.medialive.model.InputChannelLevel.wrap(item)
      }
      .toList
    override val outputChannel: __integerMin0Max7 =
      impl.outputChannel(): __integerMin0Max7
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioChannelMapping
  ): zio.aws.medialive.model.AudioChannelMapping.ReadOnly = new Wrapper(impl)
}
