package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AudioCodecSettings(
    aacSettings: Option[zio.aws.medialive.model.AacSettings] = None,
    ac3Settings: Option[zio.aws.medialive.model.Ac3Settings] = None,
    eac3Settings: Option[zio.aws.medialive.model.Eac3Settings] = None,
    mp2Settings: Option[zio.aws.medialive.model.Mp2Settings] = None,
    passThroughSettings: Option[zio.aws.medialive.model.PassThroughSettings] =
      None,
    wavSettings: Option[zio.aws.medialive.model.WavSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioCodecSettings = {
    import AudioCodecSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioCodecSettings
      .builder()
      .optionallyWith(aacSettings.map(value => value.buildAwsValue()))(
        _.aacSettings
      )
      .optionallyWith(ac3Settings.map(value => value.buildAwsValue()))(
        _.ac3Settings
      )
      .optionallyWith(eac3Settings.map(value => value.buildAwsValue()))(
        _.eac3Settings
      )
      .optionallyWith(mp2Settings.map(value => value.buildAwsValue()))(
        _.mp2Settings
      )
      .optionallyWith(passThroughSettings.map(value => value.buildAwsValue()))(
        _.passThroughSettings
      )
      .optionallyWith(wavSettings.map(value => value.buildAwsValue()))(
        _.wavSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioCodecSettings.ReadOnly =
    zio.aws.medialive.model.AudioCodecSettings.wrap(buildAwsValue())
}
object AudioCodecSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioCodecSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioCodecSettings =
      zio.aws.medialive.model.AudioCodecSettings(
        aacSettings.map(value => value.asEditable),
        ac3Settings.map(value => value.asEditable),
        eac3Settings.map(value => value.asEditable),
        mp2Settings.map(value => value.asEditable),
        passThroughSettings.map(value => value.asEditable),
        wavSettings.map(value => value.asEditable)
      )
    def aacSettings: Option[zio.aws.medialive.model.AacSettings.ReadOnly]
    def ac3Settings: Option[zio.aws.medialive.model.Ac3Settings.ReadOnly]
    def eac3Settings: Option[zio.aws.medialive.model.Eac3Settings.ReadOnly]
    def mp2Settings: Option[zio.aws.medialive.model.Mp2Settings.ReadOnly]
    def passThroughSettings
        : Option[zio.aws.medialive.model.PassThroughSettings.ReadOnly]
    def wavSettings: Option[zio.aws.medialive.model.WavSettings.ReadOnly]
    def getAacSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.AacSettings.ReadOnly] =
      AwsError.unwrapOptionField("aacSettings", aacSettings)
    def getAc3Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Ac3Settings.ReadOnly] =
      AwsError.unwrapOptionField("ac3Settings", ac3Settings)
    def getEac3Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Eac3Settings.ReadOnly] =
      AwsError.unwrapOptionField("eac3Settings", eac3Settings)
    def getMp2Settings
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mp2Settings.ReadOnly] =
      AwsError.unwrapOptionField("mp2Settings", mp2Settings)
    def getPassThroughSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.PassThroughSettings.ReadOnly
    ] = AwsError.unwrapOptionField("passThroughSettings", passThroughSettings)
    def getWavSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.WavSettings.ReadOnly] =
      AwsError.unwrapOptionField("wavSettings", wavSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioCodecSettings
  ) extends zio.aws.medialive.model.AudioCodecSettings.ReadOnly {
    override val aacSettings
        : Option[zio.aws.medialive.model.AacSettings.ReadOnly] = scala
      .Option(impl.aacSettings())
      .map(value => zio.aws.medialive.model.AacSettings.wrap(value))
    override val ac3Settings
        : Option[zio.aws.medialive.model.Ac3Settings.ReadOnly] = scala
      .Option(impl.ac3Settings())
      .map(value => zio.aws.medialive.model.Ac3Settings.wrap(value))
    override val eac3Settings
        : Option[zio.aws.medialive.model.Eac3Settings.ReadOnly] = scala
      .Option(impl.eac3Settings())
      .map(value => zio.aws.medialive.model.Eac3Settings.wrap(value))
    override val mp2Settings
        : Option[zio.aws.medialive.model.Mp2Settings.ReadOnly] = scala
      .Option(impl.mp2Settings())
      .map(value => zio.aws.medialive.model.Mp2Settings.wrap(value))
    override val passThroughSettings
        : Option[zio.aws.medialive.model.PassThroughSettings.ReadOnly] = scala
      .Option(impl.passThroughSettings())
      .map(value => zio.aws.medialive.model.PassThroughSettings.wrap(value))
    override val wavSettings
        : Option[zio.aws.medialive.model.WavSettings.ReadOnly] = scala
      .Option(impl.wavSettings())
      .map(value => zio.aws.medialive.model.WavSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioCodecSettings
  ): zio.aws.medialive.model.AudioCodecSettings.ReadOnly = new Wrapper(impl)
}
