package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__stringMin1Max35, __string}
import scala.jdk.CollectionConverters._
final case class AudioDescription(
    audioNormalizationSettings: Option[
      zio.aws.medialive.model.AudioNormalizationSettings
    ] = None,
    audioSelectorName: __string,
    audioType: Option[zio.aws.medialive.model.AudioType] = None,
    audioTypeControl: Option[
      zio.aws.medialive.model.AudioDescriptionAudioTypeControl
    ] = None,
    audioWatermarkingSettings: Option[
      zio.aws.medialive.model.AudioWatermarkSettings
    ] = None,
    codecSettings: Option[zio.aws.medialive.model.AudioCodecSettings] = None,
    languageCode: Option[__stringMin1Max35] = None,
    languageCodeControl: Option[
      zio.aws.medialive.model.AudioDescriptionLanguageCodeControl
    ] = None,
    name: __string,
    remixSettings: Option[zio.aws.medialive.model.RemixSettings] = None,
    streamName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioDescription = {
    import AudioDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioDescription
      .builder()
      .optionallyWith(
        audioNormalizationSettings.map(value => value.buildAwsValue())
      )(_.audioNormalizationSettings)
      .audioSelectorName(audioSelectorName: java.lang.String)
      .optionallyWith(audioType.map(value => value.unwrap))(_.audioType)
      .optionallyWith(audioTypeControl.map(value => value.unwrap))(
        _.audioTypeControl
      )
      .optionallyWith(
        audioWatermarkingSettings.map(value => value.buildAwsValue())
      )(_.audioWatermarkingSettings)
      .optionallyWith(codecSettings.map(value => value.buildAwsValue()))(
        _.codecSettings
      )
      .optionallyWith(languageCode.map(value => value: java.lang.String))(
        _.languageCode
      )
      .optionallyWith(languageCodeControl.map(value => value.unwrap))(
        _.languageCodeControl
      )
      .name(name: java.lang.String)
      .optionallyWith(remixSettings.map(value => value.buildAwsValue()))(
        _.remixSettings
      )
      .optionallyWith(streamName.map(value => value: java.lang.String))(
        _.streamName
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioDescription.ReadOnly =
    zio.aws.medialive.model.AudioDescription.wrap(buildAwsValue())
}
object AudioDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioDescription =
      zio.aws.medialive.model.AudioDescription(
        audioNormalizationSettings.map(value => value.asEditable),
        audioSelectorName,
        audioType.map(value => value),
        audioTypeControl.map(value => value),
        audioWatermarkingSettings.map(value => value.asEditable),
        codecSettings.map(value => value.asEditable),
        languageCode.map(value => value),
        languageCodeControl.map(value => value),
        name,
        remixSettings.map(value => value.asEditable),
        streamName.map(value => value)
      )
    def audioNormalizationSettings
        : Option[zio.aws.medialive.model.AudioNormalizationSettings.ReadOnly]
    def audioSelectorName: __string
    def audioType: Option[zio.aws.medialive.model.AudioType]
    def audioTypeControl
        : Option[zio.aws.medialive.model.AudioDescriptionAudioTypeControl]
    def audioWatermarkingSettings
        : Option[zio.aws.medialive.model.AudioWatermarkSettings.ReadOnly]
    def codecSettings
        : Option[zio.aws.medialive.model.AudioCodecSettings.ReadOnly]
    def languageCode: Option[__stringMin1Max35]
    def languageCodeControl
        : Option[zio.aws.medialive.model.AudioDescriptionLanguageCodeControl]
    def name: __string
    def remixSettings: Option[zio.aws.medialive.model.RemixSettings.ReadOnly]
    def streamName: Option[__string]
    def getAudioNormalizationSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioNormalizationSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "audioNormalizationSettings",
      audioNormalizationSettings
    )
    def getAudioSelectorName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(audioSelectorName)
    def getAudioType: ZIO[Any, AwsError, zio.aws.medialive.model.AudioType] =
      AwsError.unwrapOptionField("audioType", audioType)
    def getAudioTypeControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioDescriptionAudioTypeControl
    ] = AwsError.unwrapOptionField("audioTypeControl", audioTypeControl)
    def getAudioWatermarkingSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioWatermarkSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "audioWatermarkingSettings",
      audioWatermarkingSettings
    )
    def getCodecSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioCodecSettings.ReadOnly
    ] = AwsError.unwrapOptionField("codecSettings", codecSettings)
    def getLanguageCode: ZIO[Any, AwsError, __stringMin1Max35] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getLanguageCodeControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioDescriptionLanguageCodeControl
    ] = AwsError.unwrapOptionField("languageCodeControl", languageCodeControl)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getRemixSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.RemixSettings.ReadOnly] =
      AwsError.unwrapOptionField("remixSettings", remixSettings)
    def getStreamName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("streamName", streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioDescription
  ) extends zio.aws.medialive.model.AudioDescription.ReadOnly {
    override val audioNormalizationSettings
        : Option[zio.aws.medialive.model.AudioNormalizationSettings.ReadOnly] =
      scala
        .Option(impl.audioNormalizationSettings())
        .map(value =>
          zio.aws.medialive.model.AudioNormalizationSettings.wrap(value)
        )
    override val audioSelectorName: __string =
      impl.audioSelectorName(): __string
    override val audioType: Option[zio.aws.medialive.model.AudioType] = scala
      .Option(impl.audioType())
      .map(value => zio.aws.medialive.model.AudioType.wrap(value))
    override val audioTypeControl
        : Option[zio.aws.medialive.model.AudioDescriptionAudioTypeControl] =
      scala
        .Option(impl.audioTypeControl())
        .map(value =>
          zio.aws.medialive.model.AudioDescriptionAudioTypeControl.wrap(value)
        )
    override val audioWatermarkingSettings
        : Option[zio.aws.medialive.model.AudioWatermarkSettings.ReadOnly] =
      scala
        .Option(impl.audioWatermarkingSettings())
        .map(value =>
          zio.aws.medialive.model.AudioWatermarkSettings.wrap(value)
        )
    override val codecSettings
        : Option[zio.aws.medialive.model.AudioCodecSettings.ReadOnly] = scala
      .Option(impl.codecSettings())
      .map(value => zio.aws.medialive.model.AudioCodecSettings.wrap(value))
    override val languageCode: Option[__stringMin1Max35] =
      scala.Option(impl.languageCode()).map(value => value: __stringMin1Max35)
    override val languageCodeControl
        : Option[zio.aws.medialive.model.AudioDescriptionLanguageCodeControl] =
      scala
        .Option(impl.languageCodeControl())
        .map(value =>
          zio.aws.medialive.model.AudioDescriptionLanguageCodeControl
            .wrap(value)
        )
    override val name: __string = impl.name(): __string
    override val remixSettings
        : Option[zio.aws.medialive.model.RemixSettings.ReadOnly] = scala
      .Option(impl.remixSettings())
      .map(value => zio.aws.medialive.model.RemixSettings.wrap(value))
    override val streamName: Option[__string] =
      scala.Option(impl.streamName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioDescription
  ): zio.aws.medialive.model.AudioDescription.ReadOnly = new Wrapper(impl)
}
