package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioDescriptionAudioTypeControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl
}
object AudioDescriptionAudioTypeControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl
  ): zio.aws.medialive.model.AudioDescriptionAudioTypeControl = value match {
    case software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl.FOLLOW_INPUT =>
      val r = FOLLOW_INPUT
      r
    case software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl.USE_CONFIGURED =>
      val r = USE_CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AudioDescriptionAudioTypeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl =
      software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl.UNKNOWN_TO_SDK_VERSION
  }
  case object FOLLOW_INPUT
      extends zio.aws.medialive.model.AudioDescriptionAudioTypeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl =
      software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl.FOLLOW_INPUT
  }
  case object USE_CONFIGURED
      extends zio.aws.medialive.model.AudioDescriptionAudioTypeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl =
      software.amazon.awssdk.services.medialive.model.AudioDescriptionAudioTypeControl.USE_CONFIGURED
  }
}
