package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioDescriptionLanguageCodeControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl
}
object AudioDescriptionLanguageCodeControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl
  ): zio.aws.medialive.model.AudioDescriptionLanguageCodeControl = value match {
    case software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl.FOLLOW_INPUT =>
      val r = FOLLOW_INPUT
      r
    case software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl.USE_CONFIGURED =>
      val r = USE_CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AudioDescriptionLanguageCodeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl =
      software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl.UNKNOWN_TO_SDK_VERSION
  }
  case object FOLLOW_INPUT
      extends zio.aws.medialive.model.AudioDescriptionLanguageCodeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl =
      software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl.FOLLOW_INPUT
  }
  case object USE_CONFIGURED
      extends zio.aws.medialive.model.AudioDescriptionLanguageCodeControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl =
      software.amazon.awssdk.services.medialive.model.AudioDescriptionLanguageCodeControl.USE_CONFIGURED
  }
}
