package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class AudioLanguageSelection(
    languageCode: __string,
    languageSelectionPolicy: Option[
      zio.aws.medialive.model.AudioLanguageSelectionPolicy
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioLanguageSelection = {
    import AudioLanguageSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioLanguageSelection
      .builder()
      .languageCode(languageCode: java.lang.String)
      .optionallyWith(languageSelectionPolicy.map(value => value.unwrap))(
        _.languageSelectionPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioLanguageSelection.ReadOnly =
    zio.aws.medialive.model.AudioLanguageSelection.wrap(buildAwsValue())
}
object AudioLanguageSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioLanguageSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioLanguageSelection =
      zio.aws.medialive.model.AudioLanguageSelection(
        languageCode,
        languageSelectionPolicy.map(value => value)
      )
    def languageCode: __string
    def languageSelectionPolicy
        : Option[zio.aws.medialive.model.AudioLanguageSelectionPolicy]
    def getLanguageCode: ZIO[Any, Nothing, __string] = ZIO.succeed(languageCode)
    def getLanguageSelectionPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioLanguageSelectionPolicy
    ] = AwsError.unwrapOptionField(
      "languageSelectionPolicy",
      languageSelectionPolicy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioLanguageSelection
  ) extends zio.aws.medialive.model.AudioLanguageSelection.ReadOnly {
    override val languageCode: __string = impl.languageCode(): __string
    override val languageSelectionPolicy
        : Option[zio.aws.medialive.model.AudioLanguageSelectionPolicy] = scala
      .Option(impl.languageSelectionPolicy())
      .map(value =>
        zio.aws.medialive.model.AudioLanguageSelectionPolicy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioLanguageSelection
  ): zio.aws.medialive.model.AudioLanguageSelection.ReadOnly = new Wrapper(impl)
}
