package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioLanguageSelectionPolicy {
  def unwrap: software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy
}
object AudioLanguageSelectionPolicy {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy
  ): zio.aws.medialive.model.AudioLanguageSelectionPolicy = value match {
    case software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy.LOOSE =>
      val r = LOOSE
      r
    case software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy.STRICT =>
      val r = STRICT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AudioLanguageSelectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy =
      software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object LOOSE
      extends zio.aws.medialive.model.AudioLanguageSelectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy =
      software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy.LOOSE
  }
  case object STRICT
      extends zio.aws.medialive.model.AudioLanguageSelectionPolicy {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy =
      software.amazon.awssdk.services.medialive.model.AudioLanguageSelectionPolicy.STRICT
  }
}
