package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioNormalizationAlgorithm {
  def unwrap: software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm
}
object AudioNormalizationAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm
  ): zio.aws.medialive.model.AudioNormalizationAlgorithm = value match {
    case software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm.ITU_1770_1 =>
      val r = ITU_1770_1
      r
    case software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm.ITU_1770_2 =>
      val r = ITU_1770_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AudioNormalizationAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm =
      software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object ITU_1770_1
      extends zio.aws.medialive.model.AudioNormalizationAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm =
      software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm.ITU_1770_1
  }
  case object ITU_1770_2
      extends zio.aws.medialive.model.AudioNormalizationAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm =
      software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm.ITU_1770_2
  }
}
