package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__doubleMinNegative59Max0
import scala.jdk.CollectionConverters._
final case class AudioNormalizationSettings(
    algorithm: Option[zio.aws.medialive.model.AudioNormalizationAlgorithm] =
      None,
    algorithmControl: Option[
      zio.aws.medialive.model.AudioNormalizationAlgorithmControl
    ] = None,
    targetLkfs: Option[__doubleMinNegative59Max0] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings = {
    import AudioNormalizationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings
      .builder()
      .optionallyWith(algorithm.map(value => value.unwrap))(_.algorithm)
      .optionallyWith(algorithmControl.map(value => value.unwrap))(
        _.algorithmControl
      )
      .optionallyWith(targetLkfs.map(value => value: java.lang.Double))(
        _.targetLkfs
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioNormalizationSettings.ReadOnly =
    zio.aws.medialive.model.AudioNormalizationSettings.wrap(buildAwsValue())
}
object AudioNormalizationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioNormalizationSettings =
      zio.aws.medialive.model.AudioNormalizationSettings(
        algorithm.map(value => value),
        algorithmControl.map(value => value),
        targetLkfs.map(value => value)
      )
    def algorithm: Option[zio.aws.medialive.model.AudioNormalizationAlgorithm]
    def algorithmControl
        : Option[zio.aws.medialive.model.AudioNormalizationAlgorithmControl]
    def targetLkfs: Option[__doubleMinNegative59Max0]
    def getAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioNormalizationAlgorithm
    ] = AwsError.unwrapOptionField("algorithm", algorithm)
    def getAlgorithmControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioNormalizationAlgorithmControl
    ] = AwsError.unwrapOptionField("algorithmControl", algorithmControl)
    def getTargetLkfs: ZIO[Any, AwsError, __doubleMinNegative59Max0] =
      AwsError.unwrapOptionField("targetLkfs", targetLkfs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings
  ) extends zio.aws.medialive.model.AudioNormalizationSettings.ReadOnly {
    override val algorithm
        : Option[zio.aws.medialive.model.AudioNormalizationAlgorithm] = scala
      .Option(impl.algorithm())
      .map(value =>
        zio.aws.medialive.model.AudioNormalizationAlgorithm.wrap(value)
      )
    override val algorithmControl
        : Option[zio.aws.medialive.model.AudioNormalizationAlgorithmControl] =
      scala
        .Option(impl.algorithmControl())
        .map(value =>
          zio.aws.medialive.model.AudioNormalizationAlgorithmControl.wrap(value)
        )
    override val targetLkfs: Option[__doubleMinNegative59Max0] = scala
      .Option(impl.targetLkfs())
      .map(value => value: __doubleMinNegative59Max0)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioNormalizationSettings
  ): zio.aws.medialive.model.AudioNormalizationSettings.ReadOnly = new Wrapper(
    impl
  )
}
