package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioOnlyHlsSegmentType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType
}
object AudioOnlyHlsSegmentType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType
  ): zio.aws.medialive.model.AudioOnlyHlsSegmentType = value match {
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType.AAC =>
      val r = AAC
      r
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType.FMP4 =>
      val r = FMP4
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AudioOnlyHlsSegmentType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType.UNKNOWN_TO_SDK_VERSION
  }
  case object AAC extends zio.aws.medialive.model.AudioOnlyHlsSegmentType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType.AAC
  }
  case object FMP4 extends zio.aws.medialive.model.AudioOnlyHlsSegmentType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSegmentType.FMP4
  }
}
