package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class AudioOnlyHlsSettings(
    audioGroupId: Option[__string] = None,
    audioOnlyImage: Option[zio.aws.medialive.model.InputLocation] = None,
    audioTrackType: Option[zio.aws.medialive.model.AudioOnlyHlsTrackType] =
      None,
    segmentType: Option[zio.aws.medialive.model.AudioOnlyHlsSegmentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings = {
    import AudioOnlyHlsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings
      .builder()
      .optionallyWith(audioGroupId.map(value => value: java.lang.String))(
        _.audioGroupId
      )
      .optionallyWith(audioOnlyImage.map(value => value.buildAwsValue()))(
        _.audioOnlyImage
      )
      .optionallyWith(audioTrackType.map(value => value.unwrap))(
        _.audioTrackType
      )
      .optionallyWith(segmentType.map(value => value.unwrap))(_.segmentType)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioOnlyHlsSettings.ReadOnly =
    zio.aws.medialive.model.AudioOnlyHlsSettings.wrap(buildAwsValue())
}
object AudioOnlyHlsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioOnlyHlsSettings =
      zio.aws.medialive.model.AudioOnlyHlsSettings(
        audioGroupId.map(value => value),
        audioOnlyImage.map(value => value.asEditable),
        audioTrackType.map(value => value),
        segmentType.map(value => value)
      )
    def audioGroupId: Option[__string]
    def audioOnlyImage: Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def audioTrackType: Option[zio.aws.medialive.model.AudioOnlyHlsTrackType]
    def segmentType: Option[zio.aws.medialive.model.AudioOnlyHlsSegmentType]
    def getAudioGroupId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("audioGroupId", audioGroupId)
    def getAudioOnlyImage
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("audioOnlyImage", audioOnlyImage)
    def getAudioTrackType
        : ZIO[Any, AwsError, zio.aws.medialive.model.AudioOnlyHlsTrackType] =
      AwsError.unwrapOptionField("audioTrackType", audioTrackType)
    def getSegmentType
        : ZIO[Any, AwsError, zio.aws.medialive.model.AudioOnlyHlsSegmentType] =
      AwsError.unwrapOptionField("segmentType", segmentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings
  ) extends zio.aws.medialive.model.AudioOnlyHlsSettings.ReadOnly {
    override val audioGroupId: Option[__string] =
      scala.Option(impl.audioGroupId()).map(value => value: __string)
    override val audioOnlyImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly] = scala
      .Option(impl.audioOnlyImage())
      .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val audioTrackType
        : Option[zio.aws.medialive.model.AudioOnlyHlsTrackType] = scala
      .Option(impl.audioTrackType())
      .map(value => zio.aws.medialive.model.AudioOnlyHlsTrackType.wrap(value))
    override val segmentType
        : Option[zio.aws.medialive.model.AudioOnlyHlsSegmentType] = scala
      .Option(impl.segmentType())
      .map(value => zio.aws.medialive.model.AudioOnlyHlsSegmentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings
  ): zio.aws.medialive.model.AudioOnlyHlsSettings.ReadOnly = new Wrapper(impl)
}
