package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioOnlyHlsTrackType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType
}
object AudioOnlyHlsTrackType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType
  ): zio.aws.medialive.model.AudioOnlyHlsTrackType = value match {
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.ALTERNATE_AUDIO_AUTO_SELECT =>
      val r = ALTERNATE_AUDIO_AUTO_SELECT
      r
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT =>
      val r = ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT
      r
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.ALTERNATE_AUDIO_NOT_AUTO_SELECT =>
      val r = ALTERNATE_AUDIO_NOT_AUTO_SELECT
      r
    case software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.AUDIO_ONLY_VARIANT_STREAM =>
      val r = AUDIO_ONLY_VARIANT_STREAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AudioOnlyHlsTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALTERNATE_AUDIO_AUTO_SELECT
      extends zio.aws.medialive.model.AudioOnlyHlsTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.ALTERNATE_AUDIO_AUTO_SELECT
  }
  case object ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT
      extends zio.aws.medialive.model.AudioOnlyHlsTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT
  }
  case object ALTERNATE_AUDIO_NOT_AUTO_SELECT
      extends zio.aws.medialive.model.AudioOnlyHlsTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.ALTERNATE_AUDIO_NOT_AUTO_SELECT
  }
  case object AUDIO_ONLY_VARIANT_STREAM
      extends zio.aws.medialive.model.AudioOnlyHlsTrackType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType =
      software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType.AUDIO_ONLY_VARIANT_STREAM
  }
}
