package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__integerMin0Max8191
import scala.jdk.CollectionConverters._
final case class AudioPidSelection(pid: __integerMin0Max8191) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioPidSelection = {
    import AudioPidSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioPidSelection
      .builder()
      .pid(pid: Integer)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioPidSelection.ReadOnly =
    zio.aws.medialive.model.AudioPidSelection.wrap(buildAwsValue())
}
object AudioPidSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioPidSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioPidSelection =
      zio.aws.medialive.model.AudioPidSelection(pid)
    def pid: __integerMin0Max8191
    def getPid: ZIO[Any, Nothing, __integerMin0Max8191] = ZIO.succeed(pid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioPidSelection
  ) extends zio.aws.medialive.model.AudioPidSelection.ReadOnly {
    override val pid: __integerMin0Max8191 = impl.pid(): __integerMin0Max8191
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioPidSelection
  ): zio.aws.medialive.model.AudioPidSelection.ReadOnly = new Wrapper(impl)
}
