package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMin1
import scala.jdk.CollectionConverters._
final case class AudioSelector(
    name: __stringMin1,
    selectorSettings: Option[zio.aws.medialive.model.AudioSelectorSettings] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioSelector = {
    import AudioSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioSelector
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(selectorSettings.map(value => value.buildAwsValue()))(
        _.selectorSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioSelector.ReadOnly =
    zio.aws.medialive.model.AudioSelector.wrap(buildAwsValue())
}
object AudioSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioSelector =
      zio.aws.medialive.model
        .AudioSelector(name, selectorSettings.map(value => value.asEditable))
    def name: __stringMin1
    def selectorSettings
        : Option[zio.aws.medialive.model.AudioSelectorSettings.ReadOnly]
    def getName: ZIO[Any, Nothing, __stringMin1] = ZIO.succeed(name)
    def getSelectorSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioSelectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("selectorSettings", selectorSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioSelector
  ) extends zio.aws.medialive.model.AudioSelector.ReadOnly {
    override val name: __stringMin1 = impl.name(): __stringMin1
    override val selectorSettings
        : Option[zio.aws.medialive.model.AudioSelectorSettings.ReadOnly] = scala
      .Option(impl.selectorSettings())
      .map(value => zio.aws.medialive.model.AudioSelectorSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioSelector
  ): zio.aws.medialive.model.AudioSelector.ReadOnly = new Wrapper(impl)
}
