package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AudioSelectorSettings(
    audioHlsRenditionSelection: Option[
      zio.aws.medialive.model.AudioHlsRenditionSelection
    ] = None,
    audioLanguageSelection: Option[
      zio.aws.medialive.model.AudioLanguageSelection
    ] = None,
    audioPidSelection: Option[zio.aws.medialive.model.AudioPidSelection] = None,
    audioTrackSelection: Option[zio.aws.medialive.model.AudioTrackSelection] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioSelectorSettings = {
    import AudioSelectorSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioSelectorSettings
      .builder()
      .optionallyWith(
        audioHlsRenditionSelection.map(value => value.buildAwsValue())
      )(_.audioHlsRenditionSelection)
      .optionallyWith(
        audioLanguageSelection.map(value => value.buildAwsValue())
      )(_.audioLanguageSelection)
      .optionallyWith(audioPidSelection.map(value => value.buildAwsValue()))(
        _.audioPidSelection
      )
      .optionallyWith(audioTrackSelection.map(value => value.buildAwsValue()))(
        _.audioTrackSelection
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioSelectorSettings.ReadOnly =
    zio.aws.medialive.model.AudioSelectorSettings.wrap(buildAwsValue())
}
object AudioSelectorSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioSelectorSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioSelectorSettings =
      zio.aws.medialive.model.AudioSelectorSettings(
        audioHlsRenditionSelection.map(value => value.asEditable),
        audioLanguageSelection.map(value => value.asEditable),
        audioPidSelection.map(value => value.asEditable),
        audioTrackSelection.map(value => value.asEditable)
      )
    def audioHlsRenditionSelection
        : Option[zio.aws.medialive.model.AudioHlsRenditionSelection.ReadOnly]
    def audioLanguageSelection
        : Option[zio.aws.medialive.model.AudioLanguageSelection.ReadOnly]
    def audioPidSelection
        : Option[zio.aws.medialive.model.AudioPidSelection.ReadOnly]
    def audioTrackSelection
        : Option[zio.aws.medialive.model.AudioTrackSelection.ReadOnly]
    def getAudioHlsRenditionSelection: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioHlsRenditionSelection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "audioHlsRenditionSelection",
      audioHlsRenditionSelection
    )
    def getAudioLanguageSelection: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioLanguageSelection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "audioLanguageSelection",
      audioLanguageSelection
    )
    def getAudioPidSelection: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioPidSelection.ReadOnly
    ] = AwsError.unwrapOptionField("audioPidSelection", audioPidSelection)
    def getAudioTrackSelection: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.AudioTrackSelection.ReadOnly
    ] = AwsError.unwrapOptionField("audioTrackSelection", audioTrackSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioSelectorSettings
  ) extends zio.aws.medialive.model.AudioSelectorSettings.ReadOnly {
    override val audioHlsRenditionSelection
        : Option[zio.aws.medialive.model.AudioHlsRenditionSelection.ReadOnly] =
      scala
        .Option(impl.audioHlsRenditionSelection())
        .map(value =>
          zio.aws.medialive.model.AudioHlsRenditionSelection.wrap(value)
        )
    override val audioLanguageSelection
        : Option[zio.aws.medialive.model.AudioLanguageSelection.ReadOnly] =
      scala
        .Option(impl.audioLanguageSelection())
        .map(value =>
          zio.aws.medialive.model.AudioLanguageSelection.wrap(value)
        )
    override val audioPidSelection
        : Option[zio.aws.medialive.model.AudioPidSelection.ReadOnly] = scala
      .Option(impl.audioPidSelection())
      .map(value => zio.aws.medialive.model.AudioPidSelection.wrap(value))
    override val audioTrackSelection
        : Option[zio.aws.medialive.model.AudioTrackSelection.ReadOnly] = scala
      .Option(impl.audioTrackSelection())
      .map(value => zio.aws.medialive.model.AudioTrackSelection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioSelectorSettings
  ): zio.aws.medialive.model.AudioSelectorSettings.ReadOnly = new Wrapper(impl)
}
