package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__integerMin1000, __string}
import scala.jdk.CollectionConverters._
final case class AudioSilenceFailoverSettings(
    audioSelectorName: __string,
    audioSilenceThresholdMsec: Option[__integerMin1000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioSilenceFailoverSettings = {
    import AudioSilenceFailoverSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioSilenceFailoverSettings
      .builder()
      .audioSelectorName(audioSelectorName: java.lang.String)
      .optionallyWith(audioSilenceThresholdMsec.map(value => value: Integer))(
        _.audioSilenceThresholdMsec
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.AudioSilenceFailoverSettings.ReadOnly =
    zio.aws.medialive.model.AudioSilenceFailoverSettings.wrap(buildAwsValue())
}
object AudioSilenceFailoverSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioSilenceFailoverSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioSilenceFailoverSettings =
      zio.aws.medialive.model.AudioSilenceFailoverSettings(
        audioSelectorName,
        audioSilenceThresholdMsec.map(value => value)
      )
    def audioSelectorName: __string
    def audioSilenceThresholdMsec: Option[__integerMin1000]
    def getAudioSelectorName: ZIO[Any, Nothing, __string] =
      ZIO.succeed(audioSelectorName)
    def getAudioSilenceThresholdMsec: ZIO[Any, AwsError, __integerMin1000] =
      AwsError.unwrapOptionField(
        "audioSilenceThresholdMsec",
        audioSilenceThresholdMsec
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioSilenceFailoverSettings
  ) extends zio.aws.medialive.model.AudioSilenceFailoverSettings.ReadOnly {
    override val audioSelectorName: __string =
      impl.audioSelectorName(): __string
    override val audioSilenceThresholdMsec: Option[__integerMin1000] = scala
      .Option(impl.audioSilenceThresholdMsec())
      .map(value => value: __integerMin1000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioSilenceFailoverSettings
  ): zio.aws.medialive.model.AudioSilenceFailoverSettings.ReadOnly =
    new Wrapper(impl)
}
