package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AudioTrackSelection(
    tracks: Iterable[zio.aws.medialive.model.AudioTrack]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioTrackSelection = {
    import AudioTrackSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioTrackSelection
      .builder()
      .tracks(tracks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioTrackSelection.ReadOnly =
    zio.aws.medialive.model.AudioTrackSelection.wrap(buildAwsValue())
}
object AudioTrackSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioTrackSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioTrackSelection =
      zio.aws.medialive.model.AudioTrackSelection(tracks.map { item =>
        item.asEditable
      })
    def tracks: List[zio.aws.medialive.model.AudioTrack.ReadOnly]
    def getTracks
        : ZIO[Any, Nothing, List[zio.aws.medialive.model.AudioTrack.ReadOnly]] =
      ZIO.succeed(tracks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioTrackSelection
  ) extends zio.aws.medialive.model.AudioTrackSelection.ReadOnly {
    override val tracks: List[zio.aws.medialive.model.AudioTrack.ReadOnly] =
      impl
        .tracks()
        .asScala
        .map { item =>
          zio.aws.medialive.model.AudioTrack.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioTrackSelection
  ): zio.aws.medialive.model.AudioTrackSelection.ReadOnly = new Wrapper(impl)
}
