package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AudioType {
  def unwrap: software.amazon.awssdk.services.medialive.model.AudioType
}
object AudioType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AudioType
  ): zio.aws.medialive.model.AudioType = value match {
    case software.amazon.awssdk.services.medialive.model.AudioType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AudioType.CLEAN_EFFECTS =>
      val r = CLEAN_EFFECTS
      r
    case software.amazon.awssdk.services.medialive.model.AudioType.HEARING_IMPAIRED =>
      val r = HEARING_IMPAIRED
      r
    case software.amazon.awssdk.services.medialive.model.AudioType.UNDEFINED =>
      val r = UNDEFINED
      r
    case software.amazon.awssdk.services.medialive.model.AudioType.VISUAL_IMPAIRED_COMMENTARY =>
      val r = VISUAL_IMPAIRED_COMMENTARY
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.AudioType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioType =
      software.amazon.awssdk.services.medialive.model.AudioType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLEAN_EFFECTS extends zio.aws.medialive.model.AudioType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioType =
      software.amazon.awssdk.services.medialive.model.AudioType.CLEAN_EFFECTS
  }
  case object HEARING_IMPAIRED extends zio.aws.medialive.model.AudioType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioType =
      software.amazon.awssdk.services.medialive.model.AudioType.HEARING_IMPAIRED
  }
  case object UNDEFINED extends zio.aws.medialive.model.AudioType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioType =
      software.amazon.awssdk.services.medialive.model.AudioType.UNDEFINED
  }
  case object VISUAL_IMPAIRED_COMMENTARY
      extends zio.aws.medialive.model.AudioType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AudioType =
      software.amazon.awssdk.services.medialive.model.AudioType.VISUAL_IMPAIRED_COMMENTARY
  }
}
