package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AudioWatermarkSettings(
    nielsenWatermarksSettings: Option[
      zio.aws.medialive.model.NielsenWatermarksSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AudioWatermarkSettings = {
    import AudioWatermarkSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AudioWatermarkSettings
      .builder()
      .optionallyWith(
        nielsenWatermarksSettings.map(value => value.buildAwsValue())
      )(_.nielsenWatermarksSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AudioWatermarkSettings.ReadOnly =
    zio.aws.medialive.model.AudioWatermarkSettings.wrap(buildAwsValue())
}
object AudioWatermarkSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AudioWatermarkSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AudioWatermarkSettings =
      zio.aws.medialive.model.AudioWatermarkSettings(
        nielsenWatermarksSettings.map(value => value.asEditable)
      )
    def nielsenWatermarksSettings
        : Option[zio.aws.medialive.model.NielsenWatermarksSettings.ReadOnly]
    def getNielsenWatermarksSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.NielsenWatermarksSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nielsenWatermarksSettings",
      nielsenWatermarksSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AudioWatermarkSettings
  ) extends zio.aws.medialive.model.AudioWatermarkSettings.ReadOnly {
    override val nielsenWatermarksSettings
        : Option[zio.aws.medialive.model.NielsenWatermarksSettings.ReadOnly] =
      scala
        .Option(impl.nielsenWatermarksSettings())
        .map(value =>
          zio.aws.medialive.model.NielsenWatermarksSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AudioWatermarkSettings
  ): zio.aws.medialive.model.AudioWatermarkSettings.ReadOnly = new Wrapper(impl)
}
