package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AuthenticationScheme {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.AuthenticationScheme
}
object AuthenticationScheme {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AuthenticationScheme
  ): zio.aws.medialive.model.AuthenticationScheme = value match {
    case software.amazon.awssdk.services.medialive.model.AuthenticationScheme.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AuthenticationScheme.AKAMAI =>
      val r = AKAMAI
      r
    case software.amazon.awssdk.services.medialive.model.AuthenticationScheme.COMMON =>
      val r = COMMON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AuthenticationScheme {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AuthenticationScheme =
      software.amazon.awssdk.services.medialive.model.AuthenticationScheme.UNKNOWN_TO_SDK_VERSION
  }
  case object AKAMAI extends zio.aws.medialive.model.AuthenticationScheme {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AuthenticationScheme =
      software.amazon.awssdk.services.medialive.model.AuthenticationScheme.AKAMAI
  }
  case object COMMON extends zio.aws.medialive.model.AuthenticationScheme {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AuthenticationScheme =
      software.amazon.awssdk.services.medialive.model.AuthenticationScheme.COMMON
  }
}
