package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, __integerMin1}
import scala.jdk.CollectionConverters._
final case class AutomaticInputFailoverSettings(
    errorClearTimeMsec: Option[__integerMin1] = None,
    failoverConditions: Option[
      Iterable[zio.aws.medialive.model.FailoverCondition]
    ] = None,
    inputPreference: Option[zio.aws.medialive.model.InputPreference] = None,
    secondaryInputId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AutomaticInputFailoverSettings = {
    import AutomaticInputFailoverSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AutomaticInputFailoverSettings
      .builder()
      .optionallyWith(errorClearTimeMsec.map(value => value: Integer))(
        _.errorClearTimeMsec
      )
      .optionallyWith(
        failoverConditions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failoverConditions)
      .optionallyWith(inputPreference.map(value => value.unwrap))(
        _.inputPreference
      )
      .secondaryInputId(secondaryInputId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.AutomaticInputFailoverSettings.ReadOnly =
    zio.aws.medialive.model.AutomaticInputFailoverSettings.wrap(buildAwsValue())
}
object AutomaticInputFailoverSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AutomaticInputFailoverSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AutomaticInputFailoverSettings =
      zio.aws.medialive.model.AutomaticInputFailoverSettings(
        errorClearTimeMsec.map(value => value),
        failoverConditions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputPreference.map(value => value),
        secondaryInputId
      )
    def errorClearTimeMsec: Option[__integerMin1]
    def failoverConditions
        : Option[List[zio.aws.medialive.model.FailoverCondition.ReadOnly]]
    def inputPreference: Option[zio.aws.medialive.model.InputPreference]
    def secondaryInputId: __string
    def getErrorClearTimeMsec: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("errorClearTimeMsec", errorClearTimeMsec)
    def getFailoverConditions: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.FailoverCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("failoverConditions", failoverConditions)
    def getInputPreference
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputPreference] =
      AwsError.unwrapOptionField("inputPreference", inputPreference)
    def getSecondaryInputId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(secondaryInputId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AutomaticInputFailoverSettings
  ) extends zio.aws.medialive.model.AutomaticInputFailoverSettings.ReadOnly {
    override val errorClearTimeMsec: Option[__integerMin1] =
      scala.Option(impl.errorClearTimeMsec()).map(value => value: __integerMin1)
    override val failoverConditions
        : Option[List[zio.aws.medialive.model.FailoverCondition.ReadOnly]] =
      scala
        .Option(impl.failoverConditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.medialive.model.FailoverCondition.wrap(item)
          }.toList
        )
    override val inputPreference
        : Option[zio.aws.medialive.model.InputPreference] = scala
      .Option(impl.inputPreference())
      .map(value => zio.aws.medialive.model.InputPreference.wrap(value))
    override val secondaryInputId: __string = impl.secondaryInputId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AutomaticInputFailoverSettings
  ): zio.aws.medialive.model.AutomaticInputFailoverSettings.ReadOnly =
    new Wrapper(impl)
}
