package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailBlanking(
    availBlankingImage: Option[zio.aws.medialive.model.InputLocation] = None,
    state: Option[zio.aws.medialive.model.AvailBlankingState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AvailBlanking = {
    import AvailBlanking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AvailBlanking
      .builder()
      .optionallyWith(availBlankingImage.map(value => value.buildAwsValue()))(
        _.availBlankingImage
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AvailBlanking.ReadOnly =
    zio.aws.medialive.model.AvailBlanking.wrap(buildAwsValue())
}
object AvailBlanking {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AvailBlanking
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AvailBlanking =
      zio.aws.medialive.model.AvailBlanking(
        availBlankingImage.map(value => value.asEditable),
        state.map(value => value)
      )
    def availBlankingImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def state: Option[zio.aws.medialive.model.AvailBlankingState]
    def getAvailBlankingImage
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("availBlankingImage", availBlankingImage)
    def getState
        : ZIO[Any, AwsError, zio.aws.medialive.model.AvailBlankingState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AvailBlanking
  ) extends zio.aws.medialive.model.AvailBlanking.ReadOnly {
    override val availBlankingImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly] = scala
      .Option(impl.availBlankingImage())
      .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val state: Option[zio.aws.medialive.model.AvailBlankingState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.medialive.model.AvailBlankingState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AvailBlanking
  ): zio.aws.medialive.model.AvailBlanking.ReadOnly = new Wrapper(impl)
}
