package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait AvailBlankingState {
  def unwrap: software.amazon.awssdk.services.medialive.model.AvailBlankingState
}
object AvailBlankingState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.AvailBlankingState
  ): zio.aws.medialive.model.AvailBlankingState = value match {
    case software.amazon.awssdk.services.medialive.model.AvailBlankingState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.AvailBlankingState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.AvailBlankingState.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.AvailBlankingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AvailBlankingState =
      software.amazon.awssdk.services.medialive.model.AvailBlankingState.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.AvailBlankingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AvailBlankingState =
      software.amazon.awssdk.services.medialive.model.AvailBlankingState.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.AvailBlankingState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.AvailBlankingState =
      software.amazon.awssdk.services.medialive.model.AvailBlankingState.ENABLED
  }
}
