package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailConfiguration(
    availSettings: Option[zio.aws.medialive.model.AvailSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AvailConfiguration = {
    import AvailConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AvailConfiguration
      .builder()
      .optionallyWith(availSettings.map(value => value.buildAwsValue()))(
        _.availSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AvailConfiguration.ReadOnly =
    zio.aws.medialive.model.AvailConfiguration.wrap(buildAwsValue())
}
object AvailConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AvailConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AvailConfiguration =
      zio.aws.medialive.model
        .AvailConfiguration(availSettings.map(value => value.asEditable))
    def availSettings: Option[zio.aws.medialive.model.AvailSettings.ReadOnly]
    def getAvailSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.AvailSettings.ReadOnly] =
      AwsError.unwrapOptionField("availSettings", availSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AvailConfiguration
  ) extends zio.aws.medialive.model.AvailConfiguration.ReadOnly {
    override val availSettings
        : Option[zio.aws.medialive.model.AvailSettings.ReadOnly] = scala
      .Option(impl.availSettings())
      .map(value => zio.aws.medialive.model.AvailSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AvailConfiguration
  ): zio.aws.medialive.model.AvailConfiguration.ReadOnly = new Wrapper(impl)
}
