package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailSettings(
    scte35SpliceInsert: Option[zio.aws.medialive.model.Scte35SpliceInsert] =
      None,
    scte35TimeSignalApos: Option[zio.aws.medialive.model.Scte35TimeSignalApos] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.AvailSettings = {
    import AvailSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.AvailSettings
      .builder()
      .optionallyWith(scte35SpliceInsert.map(value => value.buildAwsValue()))(
        _.scte35SpliceInsert
      )
      .optionallyWith(scte35TimeSignalApos.map(value => value.buildAwsValue()))(
        _.scte35TimeSignalApos
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.AvailSettings.ReadOnly =
    zio.aws.medialive.model.AvailSettings.wrap(buildAwsValue())
}
object AvailSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.AvailSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.AvailSettings =
      zio.aws.medialive.model.AvailSettings(
        scte35SpliceInsert.map(value => value.asEditable),
        scte35TimeSignalApos.map(value => value.asEditable)
      )
    def scte35SpliceInsert
        : Option[zio.aws.medialive.model.Scte35SpliceInsert.ReadOnly]
    def scte35TimeSignalApos
        : Option[zio.aws.medialive.model.Scte35TimeSignalApos.ReadOnly]
    def getScte35SpliceInsert: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35SpliceInsert.ReadOnly
    ] = AwsError.unwrapOptionField("scte35SpliceInsert", scte35SpliceInsert)
    def getScte35TimeSignalApos: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Scte35TimeSignalApos.ReadOnly
    ] = AwsError.unwrapOptionField("scte35TimeSignalApos", scte35TimeSignalApos)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.AvailSettings
  ) extends zio.aws.medialive.model.AvailSettings.ReadOnly {
    override val scte35SpliceInsert
        : Option[zio.aws.medialive.model.Scte35SpliceInsert.ReadOnly] = scala
      .Option(impl.scte35SpliceInsert())
      .map(value => zio.aws.medialive.model.Scte35SpliceInsert.wrap(value))
    override val scte35TimeSignalApos
        : Option[zio.aws.medialive.model.Scte35TimeSignalApos.ReadOnly] = scala
      .Option(impl.scte35TimeSignalApos())
      .map(value => zio.aws.medialive.model.Scte35TimeSignalApos.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.AvailSettings
  ): zio.aws.medialive.model.AvailSettings.ReadOnly = new Wrapper(impl)
}
