package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchDeleteRequest(
    channelIds: Option[Iterable[__string]] = None,
    inputIds: Option[Iterable[__string]] = None,
    inputSecurityGroupIds: Option[Iterable[__string]] = None,
    multiplexIds: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchDeleteRequest = {
    import BatchDeleteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchDeleteRequest
      .builder()
      .optionallyWith(
        channelIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.channelIds)
      .optionallyWith(
        inputIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inputIds)
      .optionallyWith(
        inputSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inputSecurityGroupIds)
      .optionallyWith(
        multiplexIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.multiplexIds)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchDeleteRequest.ReadOnly =
    zio.aws.medialive.model.BatchDeleteRequest.wrap(buildAwsValue())
}
object BatchDeleteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchDeleteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchDeleteRequest =
      zio.aws.medialive.model.BatchDeleteRequest(
        channelIds.map(value => value),
        inputIds.map(value => value),
        inputSecurityGroupIds.map(value => value),
        multiplexIds.map(value => value)
      )
    def channelIds: Option[List[__string]]
    def inputIds: Option[List[__string]]
    def inputSecurityGroupIds: Option[List[__string]]
    def multiplexIds: Option[List[__string]]
    def getChannelIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("channelIds", channelIds)
    def getInputIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("inputIds", inputIds)
    def getInputSecurityGroupIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("inputSecurityGroupIds", inputSecurityGroupIds)
    def getMultiplexIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("multiplexIds", multiplexIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchDeleteRequest
  ) extends zio.aws.medialive.model.BatchDeleteRequest.ReadOnly {
    override val channelIds: Option[List[__string]] = scala
      .Option(impl.channelIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val inputIds: Option[List[__string]] = scala
      .Option(impl.inputIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val inputSecurityGroupIds: Option[List[__string]] = scala
      .Option(impl.inputSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val multiplexIds: Option[List[__string]] = scala
      .Option(impl.multiplexIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchDeleteRequest
  ): zio.aws.medialive.model.BatchDeleteRequest.ReadOnly = new Wrapper(impl)
}
