package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDeleteResponse(
    failed: Option[Iterable[zio.aws.medialive.model.BatchFailedResultModel]] =
      None,
    successful: Option[
      Iterable[zio.aws.medialive.model.BatchSuccessfulResultModel]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchDeleteResponse = {
    import BatchDeleteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchDeleteResponse
      .builder()
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failed)
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchDeleteResponse.ReadOnly =
    zio.aws.medialive.model.BatchDeleteResponse.wrap(buildAwsValue())
}
object BatchDeleteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchDeleteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchDeleteResponse =
      zio.aws.medialive.model.BatchDeleteResponse(
        failed.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failed
        : Option[List[zio.aws.medialive.model.BatchFailedResultModel.ReadOnly]]
    def successful: Option[
      List[zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly]
    ]
    def getFailed: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.BatchFailedResultModel.ReadOnly
    ]] = AwsError.unwrapOptionField("failed", failed)
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchDeleteResponse
  ) extends zio.aws.medialive.model.BatchDeleteResponse.ReadOnly {
    override val failed: Option[
      List[zio.aws.medialive.model.BatchFailedResultModel.ReadOnly]
    ] = scala
      .Option(impl.failed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.BatchFailedResultModel.wrap(item)
        }.toList
      )
    override val successful: Option[
      List[zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly]
    ] = scala
      .Option(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.BatchSuccessfulResultModel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchDeleteResponse
  ): zio.aws.medialive.model.BatchDeleteResponse.ReadOnly = new Wrapper(impl)
}
