package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchFailedResultModel(
    arn: Option[__string] = None,
    code: Option[__string] = None,
    id: Option[__string] = None,
    message: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchFailedResultModel = {
    import BatchFailedResultModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchFailedResultModel
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchFailedResultModel.ReadOnly =
    zio.aws.medialive.model.BatchFailedResultModel.wrap(buildAwsValue())
}
object BatchFailedResultModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchFailedResultModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchFailedResultModel =
      zio.aws.medialive.model.BatchFailedResultModel(
        arn.map(value => value),
        code.map(value => value),
        id.map(value => value),
        message.map(value => value)
      )
    def arn: Option[__string]
    def code: Option[__string]
    def id: Option[__string]
    def message: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchFailedResultModel
  ) extends zio.aws.medialive.model.BatchFailedResultModel.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val code: Option[__string] =
      scala.Option(impl.code()).map(value => value: __string)
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val message: Option[__string] =
      scala.Option(impl.message()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchFailedResultModel
  ): zio.aws.medialive.model.BatchFailedResultModel.ReadOnly = new Wrapper(impl)
}
