package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchScheduleActionCreateRequest(
    scheduleActions: Iterable[zio.aws.medialive.model.ScheduleAction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateRequest = {
    import BatchScheduleActionCreateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateRequest
      .builder()
      .scheduleActions(scheduleActions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.BatchScheduleActionCreateRequest.ReadOnly =
    zio.aws.medialive.model.BatchScheduleActionCreateRequest
      .wrap(buildAwsValue())
}
object BatchScheduleActionCreateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchScheduleActionCreateRequest =
      zio.aws.medialive.model
        .BatchScheduleActionCreateRequest(scheduleActions.map { item =>
          item.asEditable
        })
    def scheduleActions: List[zio.aws.medialive.model.ScheduleAction.ReadOnly]
    def getScheduleActions: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.ScheduleAction.ReadOnly
    ]] = ZIO.succeed(scheduleActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateRequest
  ) extends zio.aws.medialive.model.BatchScheduleActionCreateRequest.ReadOnly {
    override val scheduleActions
        : List[zio.aws.medialive.model.ScheduleAction.ReadOnly] = impl
      .scheduleActions()
      .asScala
      .map { item =>
        zio.aws.medialive.model.ScheduleAction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateRequest
  ): zio.aws.medialive.model.BatchScheduleActionCreateRequest.ReadOnly =
    new Wrapper(impl)
}
