package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchScheduleActionDeleteResult(
    scheduleActions: Iterable[zio.aws.medialive.model.ScheduleAction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteResult = {
    import BatchScheduleActionDeleteResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteResult
      .builder()
      .scheduleActions(scheduleActions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.BatchScheduleActionDeleteResult.ReadOnly =
    zio.aws.medialive.model.BatchScheduleActionDeleteResult
      .wrap(buildAwsValue())
}
object BatchScheduleActionDeleteResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchScheduleActionDeleteResult =
      zio.aws.medialive.model
        .BatchScheduleActionDeleteResult(scheduleActions.map { item =>
          item.asEditable
        })
    def scheduleActions: List[zio.aws.medialive.model.ScheduleAction.ReadOnly]
    def getScheduleActions: ZIO[Any, Nothing, List[
      zio.aws.medialive.model.ScheduleAction.ReadOnly
    ]] = ZIO.succeed(scheduleActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteResult
  ) extends zio.aws.medialive.model.BatchScheduleActionDeleteResult.ReadOnly {
    override val scheduleActions
        : List[zio.aws.medialive.model.ScheduleAction.ReadOnly] = impl
      .scheduleActions()
      .asScala
      .map { item =>
        zio.aws.medialive.model.ScheduleAction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteResult
  ): zio.aws.medialive.model.BatchScheduleActionDeleteResult.ReadOnly =
    new Wrapper(impl)
}
