package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchStartRequest(
    channelIds: Option[Iterable[__string]] = None,
    multiplexIds: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchStartRequest = {
    import BatchStartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchStartRequest
      .builder()
      .optionallyWith(
        channelIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.channelIds)
      .optionallyWith(
        multiplexIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.multiplexIds)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchStartRequest.ReadOnly =
    zio.aws.medialive.model.BatchStartRequest.wrap(buildAwsValue())
}
object BatchStartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchStartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchStartRequest =
      zio.aws.medialive.model.BatchStartRequest(
        channelIds.map(value => value),
        multiplexIds.map(value => value)
      )
    def channelIds: Option[List[__string]]
    def multiplexIds: Option[List[__string]]
    def getChannelIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("channelIds", channelIds)
    def getMultiplexIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("multiplexIds", multiplexIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchStartRequest
  ) extends zio.aws.medialive.model.BatchStartRequest.ReadOnly {
    override val channelIds: Option[List[__string]] = scala
      .Option(impl.channelIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val multiplexIds: Option[List[__string]] = scala
      .Option(impl.multiplexIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchStartRequest
  ): zio.aws.medialive.model.BatchStartRequest.ReadOnly = new Wrapper(impl)
}
