package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchStartResponse(
    failed: Option[Iterable[zio.aws.medialive.model.BatchFailedResultModel]] =
      None,
    successful: Option[
      Iterable[zio.aws.medialive.model.BatchSuccessfulResultModel]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchStartResponse = {
    import BatchStartResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchStartResponse
      .builder()
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failed)
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchStartResponse.ReadOnly =
    zio.aws.medialive.model.BatchStartResponse.wrap(buildAwsValue())
}
object BatchStartResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchStartResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchStartResponse =
      zio.aws.medialive.model.BatchStartResponse(
        failed.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failed
        : Option[List[zio.aws.medialive.model.BatchFailedResultModel.ReadOnly]]
    def successful: Option[
      List[zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly]
    ]
    def getFailed: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.BatchFailedResultModel.ReadOnly
    ]] = AwsError.unwrapOptionField("failed", failed)
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchStartResponse
  ) extends zio.aws.medialive.model.BatchStartResponse.ReadOnly {
    override val failed: Option[
      List[zio.aws.medialive.model.BatchFailedResultModel.ReadOnly]
    ] = scala
      .Option(impl.failed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.BatchFailedResultModel.wrap(item)
        }.toList
      )
    override val successful: Option[
      List[zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly]
    ] = scala
      .Option(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.BatchSuccessfulResultModel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchStartResponse
  ): zio.aws.medialive.model.BatchStartResponse.ReadOnly = new Wrapper(impl)
}
