package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchStopRequest(
    channelIds: Option[Iterable[__string]] = None,
    multiplexIds: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchStopRequest = {
    import BatchStopRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchStopRequest
      .builder()
      .optionallyWith(
        channelIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.channelIds)
      .optionallyWith(
        multiplexIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.multiplexIds)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchStopRequest.ReadOnly =
    zio.aws.medialive.model.BatchStopRequest.wrap(buildAwsValue())
}
object BatchStopRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchStopRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchStopRequest =
      zio.aws.medialive.model.BatchStopRequest(
        channelIds.map(value => value),
        multiplexIds.map(value => value)
      )
    def channelIds: Option[List[__string]]
    def multiplexIds: Option[List[__string]]
    def getChannelIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("channelIds", channelIds)
    def getMultiplexIds: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("multiplexIds", multiplexIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchStopRequest
  ) extends zio.aws.medialive.model.BatchStopRequest.ReadOnly {
    override val channelIds: Option[List[__string]] = scala
      .Option(impl.channelIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
    override val multiplexIds: Option[List[__string]] = scala
      .Option(impl.multiplexIds())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchStopRequest
  ): zio.aws.medialive.model.BatchStopRequest.ReadOnly = new Wrapper(impl)
}
