package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchStopResponse(
    failed: Option[Iterable[zio.aws.medialive.model.BatchFailedResultModel]] =
      None,
    successful: Option[
      Iterable[zio.aws.medialive.model.BatchSuccessfulResultModel]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchStopResponse = {
    import BatchStopResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchStopResponse
      .builder()
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failed)
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchStopResponse.ReadOnly =
    zio.aws.medialive.model.BatchStopResponse.wrap(buildAwsValue())
}
object BatchStopResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchStopResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchStopResponse =
      zio.aws.medialive.model.BatchStopResponse(
        failed.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failed
        : Option[List[zio.aws.medialive.model.BatchFailedResultModel.ReadOnly]]
    def successful: Option[
      List[zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly]
    ]
    def getFailed: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.BatchFailedResultModel.ReadOnly
    ]] = AwsError.unwrapOptionField("failed", failed)
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchStopResponse
  ) extends zio.aws.medialive.model.BatchStopResponse.ReadOnly {
    override val failed: Option[
      List[zio.aws.medialive.model.BatchFailedResultModel.ReadOnly]
    ] = scala
      .Option(impl.failed())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.BatchFailedResultModel.wrap(item)
        }.toList
      )
    override val successful: Option[
      List[zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly]
    ] = scala
      .Option(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.BatchSuccessfulResultModel.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchStopResponse
  ): zio.aws.medialive.model.BatchStopResponse.ReadOnly = new Wrapper(impl)
}
