package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchSuccessfulResultModel(
    arn: Option[__string] = None,
    id: Option[__string] = None,
    state: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchSuccessfulResultModel = {
    import BatchSuccessfulResultModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchSuccessfulResultModel
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly =
    zio.aws.medialive.model.BatchSuccessfulResultModel.wrap(buildAwsValue())
}
object BatchSuccessfulResultModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchSuccessfulResultModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchSuccessfulResultModel =
      zio.aws.medialive.model.BatchSuccessfulResultModel(
        arn.map(value => value),
        id.map(value => value),
        state.map(value => value)
      )
    def arn: Option[__string]
    def id: Option[__string]
    def state: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getState: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchSuccessfulResultModel
  ) extends zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val id: Option[__string] =
      scala.Option(impl.id()).map(value => value: __string)
    override val state: Option[__string] =
      scala.Option(impl.state()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchSuccessfulResultModel
  ): zio.aws.medialive.model.BatchSuccessfulResultModel.ReadOnly = new Wrapper(
    impl
  )
}
