package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class BatchUpdateScheduleRequest(
    channelId: __string,
    creates: Option[zio.aws.medialive.model.BatchScheduleActionCreateRequest] =
      None,
    deletes: Option[zio.aws.medialive.model.BatchScheduleActionDeleteRequest] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest = {
    import BatchUpdateScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest
      .builder()
      .channelId(channelId: java.lang.String)
      .optionallyWith(creates.map(value => value.buildAwsValue()))(_.creates)
      .optionallyWith(deletes.map(value => value.buildAwsValue()))(_.deletes)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchUpdateScheduleRequest.ReadOnly =
    zio.aws.medialive.model.BatchUpdateScheduleRequest.wrap(buildAwsValue())
}
object BatchUpdateScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchUpdateScheduleRequest =
      zio.aws.medialive.model.BatchUpdateScheduleRequest(
        channelId,
        creates.map(value => value.asEditable),
        deletes.map(value => value.asEditable)
      )
    def channelId: __string
    def creates: Option[
      zio.aws.medialive.model.BatchScheduleActionCreateRequest.ReadOnly
    ]
    def deletes: Option[
      zio.aws.medialive.model.BatchScheduleActionDeleteRequest.ReadOnly
    ]
    def getChannelId: ZIO[Any, Nothing, __string] = ZIO.succeed(channelId)
    def getCreates: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BatchScheduleActionCreateRequest.ReadOnly
    ] = AwsError.unwrapOptionField("creates", creates)
    def getDeletes: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BatchScheduleActionDeleteRequest.ReadOnly
    ] = AwsError.unwrapOptionField("deletes", deletes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest
  ) extends zio.aws.medialive.model.BatchUpdateScheduleRequest.ReadOnly {
    override val channelId: __string = impl.channelId(): __string
    override val creates: Option[
      zio.aws.medialive.model.BatchScheduleActionCreateRequest.ReadOnly
    ] = scala
      .Option(impl.creates())
      .map(value =>
        zio.aws.medialive.model.BatchScheduleActionCreateRequest.wrap(value)
      )
    override val deletes: Option[
      zio.aws.medialive.model.BatchScheduleActionDeleteRequest.ReadOnly
    ] = scala
      .Option(impl.deletes())
      .map(value =>
        zio.aws.medialive.model.BatchScheduleActionDeleteRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest
  ): zio.aws.medialive.model.BatchUpdateScheduleRequest.ReadOnly = new Wrapper(
    impl
  )
}
