package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchUpdateScheduleResponse(
    creates: Option[zio.aws.medialive.model.BatchScheduleActionCreateResult] =
      None,
    deletes: Option[zio.aws.medialive.model.BatchScheduleActionDeleteResult] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse = {
    import BatchUpdateScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse
      .builder()
      .optionallyWith(creates.map(value => value.buildAwsValue()))(_.creates)
      .optionallyWith(deletes.map(value => value.buildAwsValue()))(_.deletes)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly =
    zio.aws.medialive.model.BatchUpdateScheduleResponse.wrap(buildAwsValue())
}
object BatchUpdateScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BatchUpdateScheduleResponse =
      zio.aws.medialive.model.BatchUpdateScheduleResponse(
        creates.map(value => value.asEditable),
        deletes.map(value => value.asEditable)
      )
    def creates: Option[
      zio.aws.medialive.model.BatchScheduleActionCreateResult.ReadOnly
    ]
    def deletes: Option[
      zio.aws.medialive.model.BatchScheduleActionDeleteResult.ReadOnly
    ]
    def getCreates: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BatchScheduleActionCreateResult.ReadOnly
    ] = AwsError.unwrapOptionField("creates", creates)
    def getDeletes: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BatchScheduleActionDeleteResult.ReadOnly
    ] = AwsError.unwrapOptionField("deletes", deletes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse
  ) extends zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly {
    override val creates: Option[
      zio.aws.medialive.model.BatchScheduleActionCreateResult.ReadOnly
    ] = scala
      .Option(impl.creates())
      .map(value =>
        zio.aws.medialive.model.BatchScheduleActionCreateResult.wrap(value)
      )
    override val deletes: Option[
      zio.aws.medialive.model.BatchScheduleActionDeleteResult.ReadOnly
    ] = scala
      .Option(impl.deletes())
      .map(value =>
        zio.aws.medialive.model.BatchScheduleActionDeleteResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse
  ): zio.aws.medialive.model.BatchUpdateScheduleResponse.ReadOnly = new Wrapper(
    impl
  )
}
