package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMin34Max34
import scala.jdk.CollectionConverters._
final case class BlackoutSlate(
    blackoutSlateImage: Option[zio.aws.medialive.model.InputLocation] = None,
    networkEndBlackout: Option[
      zio.aws.medialive.model.BlackoutSlateNetworkEndBlackout
    ] = None,
    networkEndBlackoutImage: Option[zio.aws.medialive.model.InputLocation] =
      None,
    networkId: Option[__stringMin34Max34] = None,
    state: Option[zio.aws.medialive.model.BlackoutSlateState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.BlackoutSlate = {
    import BlackoutSlate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.BlackoutSlate
      .builder()
      .optionallyWith(blackoutSlateImage.map(value => value.buildAwsValue()))(
        _.blackoutSlateImage
      )
      .optionallyWith(networkEndBlackout.map(value => value.unwrap))(
        _.networkEndBlackout
      )
      .optionallyWith(
        networkEndBlackoutImage.map(value => value.buildAwsValue())
      )(_.networkEndBlackoutImage)
      .optionallyWith(networkId.map(value => value: java.lang.String))(
        _.networkId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.BlackoutSlate.ReadOnly =
    zio.aws.medialive.model.BlackoutSlate.wrap(buildAwsValue())
}
object BlackoutSlate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.BlackoutSlate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.BlackoutSlate =
      zio.aws.medialive.model.BlackoutSlate(
        blackoutSlateImage.map(value => value.asEditable),
        networkEndBlackout.map(value => value),
        networkEndBlackoutImage.map(value => value.asEditable),
        networkId.map(value => value),
        state.map(value => value)
      )
    def blackoutSlateImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def networkEndBlackout
        : Option[zio.aws.medialive.model.BlackoutSlateNetworkEndBlackout]
    def networkEndBlackoutImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly]
    def networkId: Option[__stringMin34Max34]
    def state: Option[zio.aws.medialive.model.BlackoutSlateState]
    def getBlackoutSlateImage
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField("blackoutSlateImage", blackoutSlateImage)
    def getNetworkEndBlackout: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.BlackoutSlateNetworkEndBlackout
    ] = AwsError.unwrapOptionField("networkEndBlackout", networkEndBlackout)
    def getNetworkEndBlackoutImage
        : ZIO[Any, AwsError, zio.aws.medialive.model.InputLocation.ReadOnly] =
      AwsError.unwrapOptionField(
        "networkEndBlackoutImage",
        networkEndBlackoutImage
      )
    def getNetworkId: ZIO[Any, AwsError, __stringMin34Max34] =
      AwsError.unwrapOptionField("networkId", networkId)
    def getState
        : ZIO[Any, AwsError, zio.aws.medialive.model.BlackoutSlateState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.BlackoutSlate
  ) extends zio.aws.medialive.model.BlackoutSlate.ReadOnly {
    override val blackoutSlateImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly] = scala
      .Option(impl.blackoutSlateImage())
      .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val networkEndBlackout
        : Option[zio.aws.medialive.model.BlackoutSlateNetworkEndBlackout] =
      scala
        .Option(impl.networkEndBlackout())
        .map(value =>
          zio.aws.medialive.model.BlackoutSlateNetworkEndBlackout.wrap(value)
        )
    override val networkEndBlackoutImage
        : Option[zio.aws.medialive.model.InputLocation.ReadOnly] = scala
      .Option(impl.networkEndBlackoutImage())
      .map(value => zio.aws.medialive.model.InputLocation.wrap(value))
    override val networkId: Option[__stringMin34Max34] =
      scala.Option(impl.networkId()).map(value => value: __stringMin34Max34)
    override val state: Option[zio.aws.medialive.model.BlackoutSlateState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.medialive.model.BlackoutSlateState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.BlackoutSlate
  ): zio.aws.medialive.model.BlackoutSlate.ReadOnly = new Wrapper(impl)
}
