package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait BlackoutSlateState {
  def unwrap: software.amazon.awssdk.services.medialive.model.BlackoutSlateState
}
object BlackoutSlateState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.BlackoutSlateState
  ): zio.aws.medialive.model.BlackoutSlateState = value match {
    case software.amazon.awssdk.services.medialive.model.BlackoutSlateState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.BlackoutSlateState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.BlackoutSlateState.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.BlackoutSlateState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BlackoutSlateState =
      software.amazon.awssdk.services.medialive.model.BlackoutSlateState.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.BlackoutSlateState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BlackoutSlateState =
      software.amazon.awssdk.services.medialive.model.BlackoutSlateState.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.BlackoutSlateState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BlackoutSlateState =
      software.amazon.awssdk.services.medialive.model.BlackoutSlateState.ENABLED
  }
}
