package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait BurnInAlignment {
  def unwrap: software.amazon.awssdk.services.medialive.model.BurnInAlignment
}
object BurnInAlignment {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.BurnInAlignment
  ): zio.aws.medialive.model.BurnInAlignment = value match {
    case software.amazon.awssdk.services.medialive.model.BurnInAlignment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.BurnInAlignment.CENTERED =>
      val r = CENTERED
      r
    case software.amazon.awssdk.services.medialive.model.BurnInAlignment.LEFT =>
      val r = LEFT
      r
    case software.amazon.awssdk.services.medialive.model.BurnInAlignment.SMART =>
      val r = SMART
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.BurnInAlignment {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInAlignment =
      software.amazon.awssdk.services.medialive.model.BurnInAlignment.UNKNOWN_TO_SDK_VERSION
  }
  case object CENTERED extends zio.aws.medialive.model.BurnInAlignment {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInAlignment =
      software.amazon.awssdk.services.medialive.model.BurnInAlignment.CENTERED
  }
  case object LEFT extends zio.aws.medialive.model.BurnInAlignment {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInAlignment =
      software.amazon.awssdk.services.medialive.model.BurnInAlignment.LEFT
  }
  case object SMART extends zio.aws.medialive.model.BurnInAlignment {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.BurnInAlignment =
      software.amazon.awssdk.services.medialive.model.BurnInAlignment.SMART
  }
}
